/*******************************************************
Filename		:  	DW_blob_download.sql
Release 		:  	STORET c2.0, C2.0.1
SIR			:  	1559, 1562
Description		:  	Retrieves BLOBs from the database, stores BLOBs as files, then
				displays a link for BLOB download.
Author			:  	Joseph Wilson
Date			: 	October 8, 2003
				11/05/2003 -- removed DEMO from title and updated screen messages -JW
				11/07/2003 - SIR 1562: Pass '10' into DW_bottom_of_page to process help correctly - WN
				11/11/2003 - Removed LENGTH statement, it's not necessary. found in peer review - WN
				11/13/2003 - updated page text and link name -JW
Comments		:  	Calls a Java function for io of BLOB file creation.
**********************************************************/
SET DEF OFF;

CREATE or REPLACE PROCEDURE DW_blob_download
(v_blob_id	IN	VARCHAR2)

AS
v_blob_id_split		NUMBER;
v_org_isn		NUMBER;
v_is_number		NUMBER;
v_blob 			BLOB;
v_type			CHAR(3);
out_file_name		VARCHAR2(60);
v_blob_count		NUMBER;

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  :='Download Document/Graphic';

BEGIN
	v_blob_id_split := INSTR(v_blob_id,'-');
	v_org_isn := TO_NUMBER(SUBSTR(v_blob_id, 1, v_blob_id_split-1));
	v_is_number := TO_NUMBER(SUBSTR(v_blob_id, v_blob_id_split+1));

	SELECT count(blob_type) INTO v_blob_count
		FROM fa_blob
		WHERE organization_is_number = v_org_isn
		AND tsmblob_is_number = v_is_number;

	IF v_blob_count = 1 THEN

	  	SELECT blob_content, blob_type
  			INTO   v_blob, v_type
  			FROM   fa_blob
  			WHERE organization_is_number = v_org_isn
  			AND tsmblob_is_number = v_is_number;
  
		out_file_name := TO_CHAR(SYSDATE,'YYYYMMDD_HH24MISS')||'.'||v_type;  
		out_file_name := 'BLOB'||out_file_name;  
		
	  	ExportBlob(dw_glob_var.lv_iodir||'/'||out_file_name, v_blob);

		DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
		htp.para;
		htp.para;
		htp.para;
		htp.print('<center>');
		htp.print('You have requested a Document or Graphic');
		htp.Br;
		htp.Br;
		htp.Br;
		htp.anchor(dw_glob_var.lv_download_path||out_file_name,htf.bold('Download your Document/Graphic now...'));
		htp.print('</center>');
		DW_bottom_of_page(10);
	ELSE
		DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
		htp.para;
		htp.para;
		htp.para;
		htp.print('<center>');
		--htp.print(page_title||' - You have requested to download a Document/Graphic');
		htp.print('You have requested a Document or Graphic');
		htp.Br;
		htp.Br;
		htp.Br;
		htp.print('<b>The Document/Graphic you requested is invalid or no longer exists.</b>');
		htp.print('</center>');
		DW_bottom_of_page(10);
	END IF;
END;
/
show errors;
